/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CComObject.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CComObject_h	// [
#define Included_CComObject_h

#include "pgpClassesConfig.h"
#include <objbase.h>

_PGP_BEGIN

// Class CComObject

template <typename T> class CComObject
{
	NOT_COPYABLE(CComObject)

public:
	CComObject(T *pObj);
	CComObject(REFCLSID rclsid, LPUNKNOWN pUnkOuter, PGPUInt32 clsContext, 
		REFIID riid);
	~CComObject();

	operator T *() {return mObject;}
	operator const T *() const {return mObject;}

	T *			operator->() {return mObject;}
	const T *	operator->() const {return mObject;}

	T&			operator*() {return *mObject;}
	const T&	operator*() const {return *mObject;}

	T *	Get() {return mObject;}

	void *	QueryInterface(REFIID iid) const;

private:
	T	*mObject;
};


// Class CComObject member functions

template <typename T>
inline 
CComObject<T>::CComObject(T *pObj) : mObject(pObj)
{
}

template <typename T>
inline 
CComObject<T>::CComObject(
	REFCLSID	rclsid, 
	LPUNKNOWN	pUnkOuter, 
	PGPUInt32	clsContext, 
	REFIID		riid) : mObject(NULL)
{
	PGPUInt32	result	= CoCreateInstance(rclsid, pUnkOuter, clsContext, 
		riid, reinterpret_cast<void **>(&mObject));

	if (result != S_OK)
		THROW_ERRORS(kPGPError_Win32COMOpFailed, result);
}

template <typename T>
inline 
CComObject<T>::~CComObject()
{
	if (IsntNull(mObject))
		mObject->Release();
}

template <typename T>
inline 
void *	
CComObject<T>::QueryInterface(REFIID iid) const
{
	pgpAssert(IsntNull(mObject));

	void		*pObj;
	PGPUInt32	result	= mObject->QueryInterface(iid, &pObj);

	if (result != S_OK)
		THROW_ERRORS(kPGPError_Win32COMOpFailed, result);

	return pObj;
}

_PGP_END

#endif	// ] Included_CComObject_h
